// import express 
const express = require('express') 
const studentRoutes = require('./routes/studentRoutes.js')
const bodyParser = require('body-parser')
require('dotenv').config()
const mongoose = require('mongoose')

// express app
const app = express()

// middleware 
app.use(express.json())
app.use(bodyParser.urlencoded({extended: true}))

app.get('/' , (req, res) => {
    res.sendFile(__dirname + '/index.html')
})

// app router 
app.use('/api/students', studentRoutes)

let port = process.env.PORT;

// connect database and run 
mongoose.connect(process.env.MONGDB_URL)
.then(() =>  
    app.listen(port, ()=> {
        console.log(`App is running http://localhost:${port}/ and Database is connected`)
    })
).catch((error) => console.log(error))